<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 04.02.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Zonen');
requireLogin();
requireRole(['Administrator']);
showSessionAlert();

initializeDatabaseConnection();

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0">Zonen</h4>
        <span class="text-secondary">Administration</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">

        <a href="/administration/add-zone" class="btn btn-primary btn-icon-text">
            <i class="btn-icon-prepend mdi mdi-plus"></i> Hinzufügen
        </a>

    </div>
</div>

<div class="row">
    <div class="col-12 col-md-9 order-2 order-xl-1 grid-margin">
        <div class="card">
            <div class="card-header bg-primary text-white">
                Zonen
            </div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT * FROM 
                                    Zones
                                ORDER BY 
                                    ZoneID ASC
                            ";

                    $stmt = $pdo->prepare($sql);
                    $stmt->execute();
                    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

                    if ($results) {
                        echo '<div class="table-responsive">';
                        echo "<table id='dTableAdminZones' class='table table-bordered'>";
                        echo '<thead>
                                <tr>
                                    <th style="width: 50%;">Zonenname</th>
                                    <th style="width: 50%;">Ausgangszone</th>
                                    <th style="white-space: nowrap; width: 1%;">Alarm</th>
                                    <th style="white-space: nowrap; width: 1%;">Eingeschränkt</th>
                                    <th style="white-space: nowrap; width: 1%;">Optionen</th>
                                </tr>
                            </thead>';

                        foreach ($results as $row) {
                            echo "<tr>";
                            echo "<td class='fw-bold' style='color: {$row['ZoneColor']};'>{$row['ZoneName']}</td>";
                            echo "<td>" . getZoneDetails($row['ZoneOnExit'], 'ZoneName') . "</td>";

                            if ($row['AlarmAuthorisation'] == '1') {
                                echo '<td class="text-warning fw-bold">Ja</td>';
                            } else {
                                echo '<td>Nein</td>';
                            }

                            if ($row['Restricted'] == '1') {
                                echo '<td class="text-warning fw-bold">Ja</td>';
                            } else {
                                echo '<td>Nein</td>';
                            }

                            echo '<td style="padding: .60rem .85rem;"><a href="/administration/edit-zone?id=' . $row['ZoneID'] . '" class="btn btn-sm btn-inverse-light btn-icon-text" style="margin: 0px;"><i class="mdi mdi-text-box-edit"></i> Bearbeiten</a></td>';
                            echo "</tr>";
                        }

                        echo "</table>";
                        echo '</div>';
                    } else {
                        echo '<div class="alert alert-success mb-0" role="alert">
                                <i class="mdi mdi-check-all"></i>
                                Es befinden sich keine Einträge in der Sperrliste
                            </div>
                            ';
                    }
                } catch (PDOException $e) {
                    echo "Datenbankfehler: " . $e->getMessage();
                }
                ?>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3 order-1 order-xl-2 grid-margin">
        <div class="card">
            <div class="card-header bg-warning text-white">
                Information
            </div>
            <ul class="list-group list-group-flush">
                <li class="list-group-item">In diesem Bereich können Zonen für das Buchungsterminal angelegt und
                    verwaltet werden. Diese Zonen stehen den berechtigten Benutzern im Terminal zur Auswahl und
                    ermöglichen eine gezielte Ein- und Ausbuchung in den Zutrittszonen.</li>
                <li class="list-group-item">Die Berechtigungen werden in den Benutzerkonten festgelegt.</li>
            </ul>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>